//********************************************************************
//  Building.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 4.8 (5E, p. 204)
//********************************************************************

import java.awt.Graphics;
import java.awt.Color;

public class Building
{
    private final int DEFAULT_WIDTH = 50;
    private final int DEFAULT_HEIGHT = 100;
    private final int DEFAULT_WINDOWS = 5;
    private final int WINDOW_SIZE = 5;

    private int width, height, windows;

   //-----------------------------------------------------------------
   //  Sets up this Building based on default values.
   //-----------------------------------------------------------------
   public Building ()
   {
      width = DEFAULT_WIDTH;
      height = DEFAULT_HEIGHT;
   }

   //----------------------------------------------------------------
   //  Constructor: Sets this Building's size.
   //----------------------------------------------------------------
   public Building (int buildingWidth, int buildingHeight)
   {
      width = buildingWidth;
      height = buildingHeight;
   }

   //----------------------------------------------------------------
   //  Returns the width of this building.
   //----------------------------------------------------------------
   public int getWidth ()
   {
      return width;
   }

   //----------------------------------------------------------------
   //  Draws the building.
   //----------------------------------------------------------------
   public void draw (Graphics page, int leftedge, int bottom)
   {
      int winX, winY;
      int top = bottom - height;

      page.setColor (Color.black);
      page.fillRect (leftedge, top, width, height);

      // Draw three windows in random locations
      page.setColor (Color.yellow);
      winX = leftedge + (int) (Math.random() * (width-WINDOW_SIZE));
      winY = top + (int) (Math.random() * (height-WINDOW_SIZE));
      page.fillRect (winX, winY, WINDOW_SIZE, WINDOW_SIZE);

      winX = leftedge + (int) (Math.random() * (width-WINDOW_SIZE));
      winY = top + (int) (Math.random() * (height-WINDOW_SIZE));
      page.fillRect (winX, winY, WINDOW_SIZE, WINDOW_SIZE);

      winX = leftedge + (int) (Math.random() * (width-WINDOW_SIZE));
      winY = top + (int) (Math.random() * (height-WINDOW_SIZE));
      page.fillRect (winX, winY, WINDOW_SIZE, WINDOW_SIZE);
   }
}
